import matplotlib.pyplot as plt

# Define the coordinates of the polygons
polygon1 = [(-0.8, 2.3), (-2.7, -1.7), (1.1, -4.7), (4.3, 0.5)]
polygon2 = [(-5.1, -0.6), (-1.9, -6.8), (2.9, -1.6), (-1.1, 1.7)]

# Extract x and y coordinates for each polygon
x1, y1 = zip(*polygon1)
x2, y2 = zip(*polygon2)

# Plot the polygons
plt.plot(x1, y1, 'r-', label='Polygon 1')
plt.plot(x2, y2, 'b-', label='Polygon 2')

# Find the intersection points
intersection_points = []
for i in range(len(polygon1)):
    x1, y1 = polygon1[i]
    x2, y2 = polygon1[(i+1)%len(polygon1)]
    for j in range(len(polygon2)):
        x3, y3 = polygon2[j]
        x4, y4 = polygon2[(j+1)%len(polygon2)]
        denominator = (x1-x2)*(y3-y4) - (y1-y2)*(x3-x4)
        if denominator != 0:
            intersection_x = ((x1*y2-y1*x2)*(x3-x4) - (x1-x2)*(x3*y4-y3*x4)) / denominator
            intersection_y = ((x1*y2-y1*x2)*(y3-y4) - (y1-y2)*(x3*y4-y3*x4)) / denominator
            intersection_points.append((intersection_x, intersection_y))

# Plot the intersection points
if intersection_points:
    x, y = zip(*intersection_points)
    plt.plot(x, y, 'go', label='Intersection Points')

# Set the plot title and legend
plt.title('Intersection Points of Polygons')
plt.legend()

# Save the figure
plt.savefig('figure.png')
plt.close()